--------------------------------------------------------
--  DDL for Table PREFERRED_PROVIDER
--------------------------------------------------------

  CREATE TABLE "VARDB"."PREFERRED_PROVIDER" 
   (	"PREFERRED_PROVIDER_ID" VARCHAR2(32 BYTE), 
	"CC_APPOINTMENT_REQUEST_ID" VARCHAR2(32 BYTE), 
	"FIRST_NAME" VARCHAR2(100 BYTE), 
	"LAST_NAME" VARCHAR2(100 BYTE), 
	"PRACTICE_NAME" VARCHAR2(100 BYTE), 
	"PROVIDER_STREET" VARCHAR2(100 BYTE), 
	"PROVIDER_CITY" VARCHAR2(100 BYTE), 
	"PROVIDER_STATE" VARCHAR2(2 BYTE), 
	"PROVIDER_ZIPCODE" VARCHAR2(10 BYTE),
	"PREFERRED_ORDER" NUMBER
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "VARDB_DATA" ;
REM INSERTING into VARDB.PREFERRED_PROVIDER
SET DEFINE OFF;
--------------------------------------------------------
--  DDL for Index PK_PREFERRED_PROVIDER
--------------------------------------------------------

  CREATE UNIQUE INDEX "VARDB"."PK_PREFERRED_PROVIDER" ON "VARDB"."PREFERRED_PROVIDER" ("PREFERRED_PROVIDER_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "VARDB_DATA" ;
--------------------------------------------------------
--  Constraints for Table PREFERRED_PROVIDER
--------------------------------------------------------

  ALTER TABLE "VARDB"."PREFERRED_PROVIDER" MODIFY ("PREFERRED_ORDER" NOT NULL ENABLE);
  ALTER TABLE "VARDB"."PREFERRED_PROVIDER" ADD CONSTRAINT "PK_PREFERRED_PROVIDER" PRIMARY KEY ("PREFERRED_PROVIDER_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "VARDB_DATA"  ENABLE;
  ALTER TABLE "VARDB"."PREFERRED_PROVIDER" MODIFY ("PREFERRED_PROVIDER_ID" NOT NULL ENABLE);
--------------------------------------------------------
--  Ref Constraints for Table PREFERRED_PROVIDER
--------------------------------------------------------

  ALTER TABLE "VARDB"."PREFERRED_PROVIDER" ADD CONSTRAINT "FK_PREFERRED_PROVIDER" FOREIGN KEY ("CC_APPOINTMENT_REQUEST_ID")
	  REFERENCES "VARDB"."CC_APPOINTMENT_REQUEST" ("CC_APPOINTMENT_REQUEST_ID") ENABLE;
